;                  serial 2 midi interface 89xx051
;                  ====================================
;                  TM 6 - 06
;
;   (c) by Thomas Moll, Berne, Switzerland
;
;  AT89C2051


; NAME ser2mis.a51


;_____________________________________
;
;       serial in/out part 38'400 baud
;_____________________________________


        $NOMOD51
        $INCLUDE (89c2051.mcu)   ;include ATMEL 89C2051 SFR symbol definitions


        ;14'745'600-crystal !!!



        start   CODE    0H      ;start address of user programs
        begin   CODE    028h    ;program start adress (after interrupt-jump-adresses)
        
        
        recf    BIT     02fh.7  ;set if byte received in rtmp
             
        p30     equ     P3.0    ;RX
        p31     equ     P3.1    ;TX
        ACKR    equ     P3.2    ;EXT 0  Receieve acknowledge
        STBR    equ     P3.3    ;EXT 1  Receive data strobe impulse
        ACKS    equ     P3.4    ;TI 0   send acknowledge
        STBS    equ     P3.5    ;TI 1   send data strobe impulse
        p36     equ     P3.6    ;-------- comparator output
        led     equ     P3.7    ;low will light serial led (blu)
        

        ORG start               ;program start address
        ljmp begin

        org exti0               ;org 03h
        ljmp ext0_int           ;
        
        org timer0              ;org 0bh
        ljmp tim0_int           ;

        org exti1               ;org 13h
        ljmp ext1_int           ;
        
        org timer1              ;org 1bh
        ljmp tim1_int           ;

        org sint                ;org 23h
        ljmp serial_int


        ORG begin
        
        clr EA                  ;stop all ints
        mov SP,#0fh             ;reg bank 1 ev. used...
        mov P3,#0ffh            ;all bits input
        mov P1,#0ffh            ;all bits input
        mov SCON,#50h           ;uart in mode 1 (8 bit), REN=1
        mov TMOD,#21h           ;timer 0 16-bit-mode, timer 1 mode 2 (8 bits auto reload)
        mov TL1,#0FEh           ;19200 Bds at 14'745'600 Hz (if smod=1 => 38400 baud)
        mov TH1,#0FEh           ;reload value
        mov PCON,#80h           ;double baudrate = 38400
        setb TR1                ;start timer 1 / baudrategenerator
        setb IT0                ;external int 0 on falling edge
        setb IT1                ;external int 1 on falling edge
        mov IP,#0               ;reset any priority level
        setb PX0                ;external int 0 has highest priority
        setb ES                 ;allow serial ints
        setb EX0                ;allow external 0 ints now (acknowledge)
        setb EX1                ;allow external 1 ints now (receive from midi)
        setb EA                 ;Enable global interrupts
        
   donix:
        jnb recf,donix  ;just wait...
        clr recf
        clr led         ;blue led on
        mov TH0,#080h   ;load 16-bit-timer 0 high byte (ignore low one)
        setb TR0        ;run timer 0 for led light on
        setb ET0        ;allow timer 0 int
        sjmp donix
        

   tim0_int:            ;timer0 int (software)
        setb led        ;blue led off
        clr TR0         ;stop timer 0
        clr ET0         ;disable timer-0-ints
        reti

   tim1_int:            ;timer1 int (software) 
        reti

   ext0_int:            ;external int 0 (P3.2)
        mov P1,#0ffh    ;set all inputs
        setb STBS       ;rise strobe if acknowledge received
        reti
        
   ext1_int:            ;external int 1 (P3.3)
        push acc
        push PSW
        mov a,P1        ;read byte from midi proc.
        clr ACKS        ;signalize byte read
        mov sbuf,a      ;send it with other baudrate - duplex !
        pop PSW
        pop acc
        setb ACKS       ;rise acknowledge
        reti
        
   serial_int:
        push acc
        push psw
        jnb ri,emit_it          ;test if it is a reception
        clr ri                  ;clear reception flag for next reception
        mov a,sbuf
   testro:
        jnb STBR,testro         ;do not alter P1 if still in use
        mov P1,a                ;give the received byte out to port 1
        clr STBS                ;set strobe low
        setb recf               ;mark byte received
        sjmp end_it
   emit_it:
        clr ti                  ;clear transmition flag for next transmition
   end_it:
        pop psw
        pop acc
   nothing:
        reti

   
   end