;                  serial 2 midi interface 89xx051
;                  ====================================
;                  TM 6 - 06
;
;   (c) by Thomas Moll, Berne, Switzerland
;
;  AT89C2051


; NAME ser2mim.a51


;_____________________________________
;
;       MIDI in/out part 31'350 baud
;_____________________________________



        $NOMOD51
        $INCLUDE (89c2051.mcu)   ;include ATMEL 89C4051 SFR symbol definitions


        ;following values for 24'000'000-crystal !!!


        start   CODE    0H      ;start address of user programs
        begin   CODE    028h    ;program start adress (after interrupt-jump-adresses)

        recbp   EQU     040h    ;receive buffer pointer
        sndbp   EQU     040h    ;send buffer pointer
       
        sendf   BIT     02fh.7  ;buffer control
        recf    BIT     02fh.6  ;set if midi reception
             
        p30     equ     P3.0    ;RX
        p31     equ     P3.1    ;TX
        ACKR    equ     P3.2    ;EXT 0  Receive acknowledge
        STBR    equ     P3.3    ;EXT 1  Receieve data strobe impulse
        ACKS    equ     P3.4    ;TIM 0  send acknowledge
        STBS    equ     P3.5    ;TIM 1  send data strobe impulse
        p36     equ     P3.6    ;-------- comparator output
        led     equ     P3.7    ;low=red led on
        



        ORG start               ;program start address
        ljmp begin

        org exti0               ;org 03h
        ljmp ext0_int           ;
        
        org timer0              ;org 0bh
        ljmp tim0_int           ;timer0 int: 

        org exti1               ;org 13h
        ljmp ext1_int           ;
        
        org timer1              ;org 1bh
        ljmp tim1_int           ;timer1 int: 

        org sint                ;org 23h
        ljmp serial_int


        ORG begin
        
        clr EA                  ;stop all ints
        mov SP,#0fh             ;reg bank 1 ev. used...
        mov P1,#0ffh            ;port 1 input
        mov P3,#0ffh            ;all bits input
        mov SCON,#50h           ;uart in mode 1 (8 bit), REN=1
        mov TMOD,#21h           ;timer 0 16-bit-mode, timer 1 mode 2 (8 bits auto reload)
        mov TL1,#0FCh           ;15'625 Bds at 24'000'00 Hz (if smod=1 => 31'250 baud)
        mov TH1,#0FCh           ;reload value
        mov PCON,#80h           ;double baudrate = 31'250
        mov R0,#recbp           ;R0 is receive buffer pointer
        mov R1,#sndbp           ;R1 is send buffer pointer
        clr recf
        clr sendf
        setb TR1                ;start timer 1
        setb ES                 ;allow serial ints
        setb IT0                ;external int 0 on falling edge
        setb IT1                ;external int 1 on falling edge
        setb EX0                ;allow external 0 ints now (receive from midi)
        setb EX1                ;allow external 1 ints now (acknowledge)
        setb EA                 ;Enable global interrupt
        
   donix:
        cjne R0,#recbp,sendit	;reception alters pointer value
        jnb recf,donix		;if set, will light control-LED
        clr recf
        clr led         ;red led on
        mov TH0,#040h   ;load 16-bit-timer 0 high byte
        setb TR0        ;run timer 0
        setb ET0        ;allow timer 0 int
        sjmp donix
   sendit:
        jb sendf,sendit ;if previous transmission not finished, wait
        setb sendf      ;mark new transmission starts
        mov a,@R1	;read from transmission pointer
        inc R1		;advance transmission pointer
        mov sbuf,a      ;send it
        mov a,R0
        clr C
        subb a,R1	;test, if reception pointer / transmission pointer are equal now
        jnz donix	;If not, continue transmission
        mov R0,#recbp   ;else reset buffer pointers
        mov R1,#sndbp   
        sjmp donix
        

   tim0_int:            ;timer0 int (software)
        setb led        ;red led off
        clr TR0         ;stop timer 0
        clr ET0         ;disable timer-0-ints
        reti

   tim1_int:            ;timer1 int (software) 
        reti

   ext0_int:            ;external int 0 (P3.2)
        mov P1,#0ffh    ;set all inputs
        setb STBS       ;rise strobe if acknowledge received
        reti
        
   ext1_int:            ;external int 1 (P3.3)
        push acc
        push PSW
        mov a,P1        ;fetch byte
        mov @R0,a       ;store it at receive buffer pointer
        inc R0          ;advance pointer
        clr ACKS        ;acknowledge reception
        pop PSW
        pop acc
        setb ACKS
        reti
        
   serial_int:
        push acc
        push psw
        jnb ri,emit_it          ;test if it is a reception
        clr ri                  ;clear reception flag for next reception
        setb recf               ;mark midi reception
        mov a,sbuf
   testro:
        jnb STBR,testro         ;do not alter P1 if still in use
        mov P1,a                ;give the received byte out to port 1
        clr STBS                ;set strobe low
        sjmp end_it
   emit_it:
        clr ti                  ;clear transmition flag for next transmition
        clr sendf		;mark transmission complete
   end_it:
        pop psw
        pop acc
   nothing:
        reti
               
   
   end